/*
 * Examples  : Arduino Examples By....ETT CO.,LTD
 * Program   : Call
 * Software  : Arduino 1.6.0
 * Hardware  : ET-BASE AVR EASY32U4 + ET-3G UC15 
 * Function  : Call to your phone number
 */
 
 /* Not all pins on the Leonardo support change interrupts, 
 so only the following can be used for RX: 
 8, 9, 10, 11, 14 (MISO), 15 (SCK), 16 (MOSI).*/
 
#include <SoftwareSerial.h>

SoftwareSerial mySerial(10,11); // RX, TX
 
int led = 13;                         // LED D13
char phone_number[] = "XXXXXXXXXX";   // Your phone number   Example. 089xxxxxxx

void setup() 
{ 
  mySerial.begin(9600);               // Set RS232 9600 bps
  delay(5000);
  
  mySerial.print("ATD");              // Call to your phone number
  mySerial.print(phone_number);
  mySerial.print(";\r");
  
  delay(15000);                    
  mySerial.print("ATH\r");            // End call              
} 
  
void loop() 
{ 
  digitalWrite(led, HIGH);   
  delay(500);               
  digitalWrite(led, LOW);    
  delay(500);  
} 


